#ifndef __Player_h__
#define __Player_h__

#pragma warning (disable : 4786)

#include <lib3d/model/loader/objloader.h>
#include <lib3d/model/loader/MS3DLoader.h>
#include <lib3d/model/loader/MD2Loader.h>
#include "ogl.h"

#ifndef DToR
#define DToR(x) ((x)*3.1415926535897932384626433832795/180.0)
#endif
#ifndef RToD
#define RToD(x) ((x)*180.0/3.1415926535897932384626433832795)
#endif

#define WHEEL_COUNT 3
#define MAX_ENERGY  0
#define MAX_AMMO    15
#define MAX_JUMP    3
#define PLAYER_R    0.2f

const float wheel_pos_offset = 0.1f;
const float vehicle_scale = 0.1f;
const int   wheel_cnt = WHEEL_COUNT;

class Player {

public:
   
   Player(float posx=0,float posy=0,float angle=0);
   ~Player();

   void  setId(int id) { this->id = id; };
   int   getId() { return id; };
   void  setPos(float x,float y);
   void  setColor(float r,float g,float b);
   float getTurretAngle() { return turret_angle; };
   void  setTurretAngle(float tang) { turret_angle = tang; };
   float getPosX() { return posx; };
   float getPosY() { return posy; };
   void  setEnergy(int e) { if (e <= MAX_ENERGY) energy = e; }
   int   getEnergy() { return energy; }
   void  setSpeed(float spd) { speed = spd; }
   float getSpeed() { return speed; }
   void  setSteerEnergy(float e) { steer_energy = e; }
   float getSteerEnergy() { return steer_energy; }
   void  setThrowForce(float tf);
   float getThrowForce() { return throw_force; }
   void  setAmmo(int ammo) { if (ammo <= MAX_AMMO) this->ammo = ammo; };
   int   getAmmo() { return ammo; };
   bool  checkCollision(float x,float y,float r);
   void  getWheelPos(float *wposx,float *wposy);
   void  setWheelPos(const float *wposx,const float *wposy);
   void  setWheelPosAgainstCenter();
   void  setScore(int s) { score = s; };
   int   getScore() { return score; };
   void  turnTurret(float deg);
   float getBodyAngle() { return body_angle; }
   bool  canFireWeapon() { return ammo > 0 && fireTimeout < 0; };
   void  weaponFired();
   void  reset();
   void  beginJump(float xforce,float yforce);
   void  endJump() { jumping = false; jumpcnt = 0; }
   bool  isJumping() { return jumping; }
   void  faceToRight(bool b) { face_to_right = b; }
   bool  isfaceToRight() { return face_to_right; }
   void  runAnimation(int anum,bool oneshot=false) { amodel->activeAnimation(anum,oneshot); }
   
   void  init();
   void  update(float dt);
   void  render(float r,float g,float b);

protected:
   int   id;
   float posx,posy;
   float wheelposx[wheel_cnt],wheelposy[wheel_cnt];
   float turret_angle;
   float body_angle;
   int   energy;
   float steer_energy;
   float throw_force;
   float speed;
   int   ammo;
   float fireTimeout;
   int   score;
   float jumpForce[2];     // x,y
   bool  jumping;
   int   jumpcnt;
   bool  face_to_right;

   float colr,colg,colb;

   Model *vmodel;
   Model *wmodel;
   //SkeletalModel *sm;
   AnimatedModel *amodel;


};


#endif